﻿using System;
using System.Collections;

namespace CSharpBuch.Kap16
{
  class Aufgabe7 : IEnumerable
  {
    ArrayList dvdList = new ArrayList();

    public Aufgabe7()
    {
      dvdList.Add(new DVDElement("Scooter", 2005, 19.95));
      dvdList.Add(new DVDElement("The Cure", 1987, 16.99));
      dvdList.Add(new DVDElement("Schiller", 1999, 7.99));
      dvdList.Add(new DVDElement("Depeche Mode", 1986, 11.24));
      dvdList.Add(new DVDElement("Hocico", 2003, 9.99));
    }

    public void Sort(IComparer comp)
    {
      dvdList.Sort(comp);
    }

    static void Main(string[] args)
    {
      Aufgabe7 a7 = new Aufgabe7();

      Console.WriteLine("Sortiert nach Erscheinungsjahr und Titel");
      a7.Sort(new DVDElementComparer1());
      foreach (DVDElement elem in a7)
        Console.WriteLine("{0}, {1}, {2}", elem.Erscheinungsjahr, elem.Titel, elem.Preis);

      Console.WriteLine("\nSortiert nach Preis");
      a7.Sort(new DVDElementComparer2());
      foreach (DVDElement elem in a7)
        Console.WriteLine("{0}, {1}, {2}", elem.Erscheinungsjahr, elem.Titel, elem.Preis);

      Console.ReadLine();
    }

    public IEnumerator GetEnumerator()
    {
      for (int i = 0; i < dvdList.Count; i++)
        yield return dvdList[i];
    }
  }

  public class DVDElement
  {
    private string titel;
    private int erscheinungsjahr;
    private double preis;

    public string Titel
    {
      get
      {
        return titel;
      }
    }

    public int Erscheinungsjahr
    {
      get
      {
        return erscheinungsjahr;
      }
    }

    public double Preis
    {
      get
      {
        return preis;
      }
    }

    public DVDElement(string titel, int erscheinungsjahr, double preis)
    {
      this.titel = titel;
      this.erscheinungsjahr = erscheinungsjahr;
      this.preis = preis;
    }
  }
  class DVDElementComparer1 : IComparer
  {
    public int Compare(object x, object y)
    {
      if ((x is DVDElement) & (y is DVDElement))
      {
        DVDElement dvd1 = x as DVDElement;
        DVDElement dvd2 = y as DVDElement;

        if (dvd1.Erscheinungsjahr == dvd2.Erscheinungsjahr)
          return dvd1.Titel.CompareTo(dvd2.Titel);
        else
        {
          if (dvd1.Erscheinungsjahr > dvd2.Erscheinungsjahr)
            return 1;
          else
            return -1;
        }
      }
      else
        throw new ApplicationException("Falsche Parametertypen");
    }
  }
  class DVDElementComparer2 : IComparer
  {
    public int Compare(object x, object y)
    {
      if ((x is DVDElement) & (y is DVDElement))
      {
        DVDElement dvd1 = x as DVDElement;
        DVDElement dvd2 = y as DVDElement;

        if (dvd1.Preis == dvd2.Preis)
          return 0;
        else
        {
          if (dvd1.Preis > dvd2.Preis)
            return 1;
          else
            return -1;
        }
      }
      else
        throw new ApplicationException("Falsche Parametertypen");
    }
  }
}